from pyscipopt import Model
import pandas as pd

instances_train = []
instances_valid = []
instances_test = []

instances_train += ["data/instances/anonymous/train/anonymous_{}.mps.gz".format(i) for i in range(98)]
instances_valid += ["data/instances/anonymous/valid/anonymous_{}.mps.gz".format(i + 98) for i in range(20)]
instances_test += ["data/instances/anonymous/test/anonymous_{}.mps.gz".format(i + 119) for i in range(20)]

ins_list = []
num_cons = []
num_vars = []

# num_inte = []
# num_bin = []
for ins in instances_train + instances_valid + instances_test:
    print(ins)
    model = Model()
    model.readProblem(ins)

    ins_list.append(ins)

    num_cons.append(model.getNConss())
    num_vars.append(model.getNVars())

    # num_inte.append(model.getNIntVars())
    # num_bin.append(model.getNBinVars())

df = pd.DataFrame()
df['ins'] = ins_list
df['Cons'] = num_cons
df['Vars'] = num_vars
# df['Integer'] = num_inte
# df['Binary'] = num_bin

df.to_csv("miplib_sta.csv", index=False)